/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.iterativedeepening;

import com.fathzer.games.ai.DepthFirstAI;
import com.fathzer.games.ai.DepthFirstSearchParameters;
import com.fathzer.games.ai.SearchResult;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.iterativedeepening.DeepeningPolicy;
import com.fathzer.games.ai.iterativedeepening.IterativeDeepeningEngine;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import com.fathzer.games.util.SortedUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;

public class IterativeDeepeningSearch<M> {
    private final DeepeningPolicy deepeningPolicy;
    private final DepthFirstAI<M, DepthFirstSearchParameters> ai;
    private SearchHistory<M> searchHistory;
    private List<M> searchedMoves;
    private IterativeDeepeningEngine.SearchEventLogger<M> logger;
    private int depth;

    public IterativeDeepeningSearch(DepthFirstAI<M, DepthFirstSearchParameters> ai, DeepeningPolicy deepeningPolicy) {
        this.ai = ai;
        this.logger = new IterativeDeepeningEngine.Mute();
        this.deepeningPolicy = deepeningPolicy;
    }

    public void setSearchedMoves(List<M> searchedMoves) {
        if (this.searchHistory != null) {
            throw new IllegalStateException("The search history has already been built");
        }
        this.searchedMoves = searchedMoves;
    }

    public void interrupt() {
        this.ai.interrupt();
    }

    public void setEventLogger(IterativeDeepeningEngine.SearchEventLogger<M> logger) {
        if (this.searchHistory != null) {
            throw new IllegalStateException("The search history has already been built");
        }
        this.logger = logger;
    }

    private SearchHistory<M> buildBestMoves() {
        this.deepeningPolicy.start();
        this.searchHistory = new SearchHistory(this.deepeningPolicy);
        final DepthFirstSearchParameters currentParams = new DepthFirstSearchParameters(this.deepeningPolicy.getStartDepth(), this.deepeningPolicy.getSize(), this.deepeningPolicy.getAccuracy());
        SearchResult bestMoves = this.searchedMoves == null ? this.ai.getBestMoves(currentParams) : this.ai.getBestMoves(this.searchedMoves, currentParams);
        this.searchHistory.add(bestMoves.getList(), this.deepeningPolicy.getStartDepth());
        this.logger.logSearchAtDepth(currentParams.getDepth(), this.ai.getStatistics(), bestMoves);
        long maxTime = this.deepeningPolicy.getMaxTime();
        long remaining = maxTime - this.deepeningPolicy.getSpent();
        if (!this.deepeningPolicy.isEnoughTimeToDeepen(currentParams.getDepth())) {
            return this.searchHistory;
        }
        Timer timer = new Timer(true);
        if (maxTime != Long.MAX_VALUE) {
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    IterativeDeepeningSearch.this.ai.interrupt();
                    IterativeDeepeningSearch.this.logger.logTimeOut(currentParams.getDepth());
                }
            }, remaining);
        }
        List<EvaluatedMove<Object>> evaluatedMoves = bestMoves.getList();
        ArrayList ended = new ArrayList(evaluatedMoves.size());
        while (currentParams.getDepth() < this.deepeningPolicy.getDepth()) {
            List moves;
            List<Object> list = moves = this.deepeningPolicy.isEnoughTimeToDeepen(this.depth) ? this.deepeningPolicy.getMovesToDeepen(currentParams, this.searchHistory, evaluatedMoves) : Collections.emptyList();
            if (moves.isEmpty()) {
                this.logger.logEndedByPolicy(currentParams.getDepth());
            } else {
                if (moves.size() != evaluatedMoves.size()) {
                    evaluatedMoves.stream().filter(em -> !moves.contains(em.getMove())).forEach(ended::add);
                }
                currentParams.setDepth(this.deepeningPolicy.getNextDepth(currentParams.getDepth()));
                SearchResult deeper = this.ai.getBestMoves(moves, currentParams);
                evaluatedMoves = deeper.getList();
                this.depth = currentParams.getDepth();
                this.logger.logSearchAtDepth(this.depth, this.ai.getStatistics(), deeper);
                Optional<SearchResult<SearchResult>> stepResult = this.ai.isInterrupted() ? this.deepeningPolicy.mergeInterrupted(this.searchHistory, deeper, this.depth) : Optional.of(deeper);
                stepResult.ifPresent(r -> this.searchHistory.add(IterativeDeepeningSearch.complete(r, ended), this.depth));
            }
            if (!this.ai.isInterrupted() && !moves.isEmpty()) continue;
            break;
        }
        timer.cancel();
        return this.searchHistory;
    }

    private static <M> List<EvaluatedMove<M>> complete(SearchResult<M> result, List<EvaluatedMove<M>> ended) {
        if (ended.isEmpty()) {
            return result.getList();
        }
        ArrayList moves = new ArrayList(result.getList());
        ended.stream().forEach(em -> SortedUtils.insert(moves, em));
        return moves;
    }

    public SearchHistory<M> getSearchHistory() {
        if (this.searchHistory == null) {
            this.searchHistory = this.buildBestMoves();
        }
        return this.searchHistory;
    }
}

