/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.iterativedeepening;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.Negamax;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.games.ai.SearchResult;
import com.fathzer.games.ai.SearchStatistics;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.iterativedeepening.DeepeningPolicy;
import com.fathzer.games.ai.iterativedeepening.IterativeDeepeningSearch;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import com.fathzer.games.ai.transposition.TTAi;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.games.movelibrary.MoveLibrary;
import com.fathzer.games.util.exec.ExecutionContext;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;

public class IterativeDeepeningEngine<M, B extends MoveGenerator<M>> {
    private MoveLibrary<M, B> movesLibrary;
    private Supplier<Evaluator<M, B>> evaluatorSupplier;
    private DeepeningPolicy deepeningPolicy;
    private TranspositionTable<M, B> transpositionTable;
    private int parallelism = 1;
    private EngineEventLogger<M, B> logger;
    private IterativeDeepeningSearch<M> rs;
    private AtomicBoolean running;

    public IterativeDeepeningEngine(DeepeningPolicy deepeningPolicy, TranspositionTable<M, B> tt, Supplier<Evaluator<M, B>> evaluatorSupplier) {
        this.transpositionTable = tt;
        this.evaluatorSupplier = evaluatorSupplier;
        this.running = new AtomicBoolean();
        this.logger = new Mute();
        this.deepeningPolicy = deepeningPolicy;
    }

    public void interrupt() {
        if (this.running.get()) {
            this.rs.interrupt();
        }
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public void setParallelism(int parallelism) {
        this.parallelism = parallelism;
    }

    public void setOpenings(MoveLibrary<M, B> library) {
        this.movesLibrary = library;
    }

    public Supplier<Evaluator<M, B>> getEvaluationSupplier() {
        return this.evaluatorSupplier;
    }

    public void setEvaluatorSupplier(Supplier<Evaluator<M, B>> evaluatorSupplier) {
        this.evaluatorSupplier = evaluatorSupplier;
    }

    public EngineEventLogger<M, B> getLogger() {
        return this.logger;
    }

    public void setLogger(EngineEventLogger<M, B> logger) {
        this.logger = logger;
    }

    public TranspositionTable<M, B> getTranspositionTable() {
        return this.transpositionTable;
    }

    public void setTranspositionTable(TranspositionTable<M, B> transpositionTable) {
        this.transpositionTable = transpositionTable;
    }

    public DeepeningPolicy getDeepeningPolicy() {
        return this.deepeningPolicy;
    }

    public void setDeepeningPolicy(DeepeningPolicy policy) {
        this.deepeningPolicy = policy;
    }

    public void newGame() {
        if (this.movesLibrary != null) {
            this.movesLibrary.newGame();
        }
        if (this.transpositionTable != null) {
            this.transpositionTable.newGame();
        }
    }

    public SearchHistory<M> getBestMoves(B board, List<M> searchedMoves) {
        EvaluatedMove move;
        SearchHistory result = new SearchHistory(this.deepeningPolicy);
        EvaluatedMove evaluatedMove = move = this.movesLibrary == null ? null : (EvaluatedMove)((Optional)this.movesLibrary.apply((Object)board)).orElse(null);
        if (move != null) {
            this.logger.logLibraryMove(board, move);
            result.add(Collections.singletonList(move), 0);
            return result;
        }
        IterativeDeepeningSearch<M> search = this.doSearch(board, searchedMoves);
        return search.getSearchHistory();
    }

    public SearchHistory<M> getBestMoves(B board) {
        return this.getBestMoves(board, null);
    }

    protected IterativeDeepeningSearch<M> doSearch(B board, List<M> searchedMoves) {
        if (!this.running.compareAndSet(false, true)) {
            throw new IllegalStateException();
        }
        try {
            this.logger.logSearchStart(board, this);
            if (this.transpositionTable != null) {
                this.transpositionTable.newPosition(board);
            }
            ExecutionContext<SearchContext<M, B>> context = this.buildExecutionContext(board);
            try {
                TTAi<M, B> internal = this.buildAI(context);
                internal.setTranspositonTable(this.transpositionTable);
                this.rs = new IterativeDeepeningSearch<M>(internal, this.deepeningPolicy);
                this.rs.setEventLogger(this.logger);
                this.rs.setSearchedMoves(searchedMoves);
                this.logger.logSearchEnd(board, this.rs.getSearchHistory());
                IterativeDeepeningSearch<M> iterativeDeepeningSearch = this.rs;
                if (context != null) {
                    context.close();
                }
                return iterativeDeepeningSearch;
            }
            catch (Throwable throwable) {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        finally {
            this.running.set(false);
        }
    }

    protected ExecutionContext<SearchContext<M, B>> buildExecutionContext(B board) {
        SearchContext<M, B> context = SearchContext.get(board, this.evaluatorSupplier);
        return ExecutionContext.get(this.getParallelism(), context);
    }

    protected TTAi<M, B> buildAI(ExecutionContext<SearchContext<M, B>> context) {
        return new Negamax<M, B>(context);
    }

    public static final class Mute<M, B extends MoveGenerator<M>>
    implements EngineEventLogger<M, B> {
    }

    public static interface EngineEventLogger<M, B extends MoveGenerator<M>>
    extends SearchEventLogger<M> {
        default public void logLibraryMove(B board, EvaluatedMove<M> move) {
        }

        default public void logSearchStart(B board, IterativeDeepeningEngine<M, B> engine) {
        }

        default public void logSearchEnd(B board, SearchHistory<M> result) {
        }
    }

    public static interface SearchEventLogger<M> {
        default public void logSearchAtDepth(int depth, SearchStatistics stats, SearchResult<M> results) {
        }

        default public void logTimeOut(int depth) {
        }

        default public void logEndedByPolicy(int depth) {
        }
    }
}

