/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.iterativedeepening;

import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import com.fathzer.games.ai.moveselector.MoveSelector;
import java.util.List;

public class FirstBestMoveSelector<M>
extends MoveSelector<M, SearchHistory<M>> {
    @Override
    public List<EvaluatedMove<M>> select(SearchHistory<M> history, List<EvaluatedMove<M>> result) {
        return super.select(history, this.filter(history, result));
    }

    protected List<EvaluatedMove<M>> filter(SearchHistory<M> history, List<EvaluatedMove<M>> bestMoves) {
        for (int i = history.length() - 1; i >= 0 && bestMoves.size() != 1; --i) {
            List<EvaluatedMove<M>> depthList = history.getList(i);
            List<EvaluatedMove<M>> best = depthList.subList(0, history.getSearchParameters().getBestMovesCount(depthList));
            List<Object> cut = best.stream().map(EvaluatedMove::getMove).toList();
            bestMoves = this.filter(bestMoves, cut);
            this.log(history, i, cut, bestMoves);
        }
        return bestMoves;
    }

    protected void log(SearchHistory<M> history, int index, List<M> cut, List<EvaluatedMove<M>> result) {
    }

    private List<EvaluatedMove<M>> filter(List<EvaluatedMove<M>> bestMoves, List<M> moves) {
        List<EvaluatedMove> alreadyBest = bestMoves.stream().filter(em -> moves.contains(em.getMove())).toList();
        return alreadyBest.isEmpty() ? bestMoves : alreadyBest;
    }
}

