/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.iterativedeepening;

import com.fathzer.games.ai.DepthFirstSearchParameters;
import com.fathzer.games.ai.SearchResult;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.ai.iterativedeepening.SearchHistory;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DeepeningPolicy
extends DepthFirstSearchParameters {
    private long maxTime = Long.MAX_VALUE;
    private long start = -1L;
    private boolean deepenOnForced = false;

    public DeepeningPolicy(int maxDepth) {
        super(maxDepth);
    }

    public void start() {
        this.start = System.currentTimeMillis();
    }

    public long getSpent() {
        if (this.start < 0L) {
            throw new IllegalStateException("Not yet started");
        }
        return System.currentTimeMillis() - this.start;
    }

    public void setMaxTime(long maxTime) {
        this.maxTime = maxTime;
        this.start = -1L;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    public boolean isDeepenOnForced() {
        return this.deepenOnForced;
    }

    public void setDeepenOnForced(boolean deepenOnForced) {
        this.deepenOnForced = deepenOnForced;
    }

    public int getStartDepth() {
        return Math.min(2, this.getDepth());
    }

    public int getNextDepth(int currentDepth) {
        return currentDepth + 1;
    }

    public boolean isEnoughTimeToDeepen(int depth) {
        return this.getSpent() < this.maxTime / 2L;
    }

    public <M> List<M> getMovesToDeepen(DepthFirstSearchParameters currentParams, SearchHistory<M> history, List<EvaluatedMove<M>> evaluations) {
        evaluations = this.filterWinLooseMoves(currentParams, history, evaluations);
        return this.deepenOnForced || evaluations.size() > 1 ? evaluations.stream().map(EvaluatedMove::getMove).toList() : Collections.emptyList();
    }

    protected <M> List<EvaluatedMove<M>> filterWinLooseMoves(DepthFirstSearchParameters currentParams, SearchHistory<M> history, List<EvaluatedMove<M>> evaluatedMoves) {
        AtomicInteger size = new AtomicInteger(currentParams.getSize());
        List<EvaluatedMove<M>> list = evaluatedMoves.stream().filter(em -> {
            Evaluation.Type type = em.getEvaluation().getType();
            if (type != Evaluation.Type.EVAL && currentParams.getDepth() / 2 < em.getEvaluation().getCountToEnd()) {
                type = Evaluation.Type.EVAL;
            }
            if (type == Evaluation.Type.WIN) {
                size.decrementAndGet();
            }
            return type == Evaluation.Type.EVAL;
        }).toList();
        if (size.get() > 0) {
            currentParams.setSize(size.get());
            return list;
        }
        return Collections.emptyList();
    }

    public <M> Optional<SearchResult<M>> mergeInterrupted(SearchHistory<M> history, SearchResult<M> interruptedSearch, int interruptionDepth) {
        List<EvaluatedMove<M>> partialList = interruptedSearch.getList();
        if (partialList.isEmpty() || !this.areMergeable(history.getAccurateMoves(), partialList)) {
            return Optional.empty();
        }
        List<EvaluatedMove<M>> historyMoves = history.getLastList();
        int previousLow = this.getLowerBound(historyMoves);
        boolean trap = partialList.get(partialList.size() - 1).getScore() <= previousLow;
        SearchResult mergedResult = new SearchResult(this);
        if (trap) {
            int unkownScore = partialList.get(partialList.size() - 1).getEvaluation().getScore() - 1;
            historyMoves.stream().map(EvaluatedMove::getMove).collect(Collectors.toCollection(ArrayDeque::new)).descendingIterator().forEachRemaining(m -> mergedResult.update(m, Evaluation.score(unkownScore)));
        } else {
            historyMoves.forEach(em -> mergedResult.add(em.getMove(), em.getEvaluation()));
        }
        partialList.forEach(ev -> mergedResult.update(ev.getMove(), ev.getEvaluation()));
        return Optional.of(mergedResult);
    }

    private <M> boolean areMergeable(List<EvaluatedMove<M>> cut, List<EvaluatedMove<M>> partialList) {
        for (EvaluatedMove cutEvalMove : cut) {
            boolean notFound = partialList.stream().filter(em -> em.getMove().equals(cutEvalMove.getMove())).findAny().isEmpty();
            if (!notFound) continue;
            return false;
        }
        return true;
    }
}

