/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.evaluation;

import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.util.exec.Forkable;

public interface Evaluator<M, B>
extends Forkable<Evaluator<M, B>> {
    public void init(B var1);

    public void prepareMove(B var1, M var2);

    public void commitMove();

    public void unmakeMove();

    public int evaluate(B var1);

    default public int getWinScore(int nbHalfMoves) {
        return Short.MAX_VALUE - nbHalfMoves;
    }

    default public int getNbHalfMovesToWin(int winScore) {
        return Short.MAX_VALUE - Math.abs(winScore);
    }

    default public boolean isWinLooseScore(int score) {
        return Math.abs(score) > 32511;
    }

    default public Evaluation toEvaluation(int score) {
        if (this.isWinLooseScore(score)) {
            int endCount = (this.getNbHalfMovesToWin(Math.abs(score)) + 1) / 2;
            return score > 0 ? Evaluation.win(endCount, score) : Evaluation.loose(endCount, score);
        }
        return Evaluation.score(score);
    }
}

