/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.evaluation;

import java.util.Comparator;

public class Evaluation
implements Comparable<Evaluation> {
    public static final Comparator<Evaluation> REVERSE = Comparator.comparingInt(Evaluation::getScore).reversed();
    private final Type type;
    private final int score;
    private final int countToEnd;
    public static final Evaluation UNKNOWN = new Evaluation(Type.UNKNOWN, 0, Integer.MAX_VALUE);

    private Evaluation(Type type, int score, int nbMovesToEnd) {
        this.type = type;
        this.score = score;
        this.countToEnd = nbMovesToEnd;
    }

    public static Evaluation win(int nbMoves, int score) {
        return new Evaluation(Type.WIN, score, nbMoves);
    }

    public static Evaluation loose(int nbMoves, int score) {
        return new Evaluation(Type.LOOSE, score, nbMoves);
    }

    public static Evaluation score(int score) {
        return new Evaluation(Type.EVAL, score, Integer.MAX_VALUE);
    }

    public Type getType() {
        return this.type;
    }

    public int getScore() {
        return this.score;
    }

    public int getCountToEnd() {
        return this.countToEnd;
    }

    @Override
    public int compareTo(Evaluation other) {
        long diff = (long)this.getScore() - (long)other.getScore();
        if (diff == 0L) {
            return 0;
        }
        return diff < 0L ? -1 : 1;
    }

    public int hashCode() {
        return this.getScore();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Evaluation other = (Evaluation)obj;
        return other.type == this.type && other.countToEnd == this.countToEnd && this.score == other.score && this.type == other.type;
    }

    public String toString() {
        return this.type == Type.EVAL ? Integer.toString(this.score) : this.type + "+" + this.getCountToEnd();
    }

    public static enum Type {
        LOOSE,
        EVAL,
        WIN,
        UNKNOWN;

    }
}

