/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai.evaluation;

import com.fathzer.games.ai.evaluation.Evaluation;
import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;

public class EvaluatedMove<M>
implements Comparable<EvaluatedMove<M>> {
    private final M content;
    private final Evaluation value;

    public EvaluatedMove(M move, Evaluation evaluation) {
        this.content = move;
        this.value = evaluation;
    }

    public M getMove() {
        return this.content;
    }

    public Evaluation getEvaluation() {
        return this.value;
    }

    public int getScore() {
        return this.value.getScore();
    }

    public boolean isEnd() {
        return this.value.getType() != Evaluation.Type.EVAL;
    }

    @Override
    public int compareTo(EvaluatedMove<M> other) {
        return other.getEvaluation().compareTo(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EvaluatedMove other = (EvaluatedMove)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString(Function<M, String> toString) {
        return toString.apply(this.content) + "(" + this.getEvaluation() + ")";
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public static <M> String toString(Collection<EvaluatedMove<M>> moves, Function<M, String> toString) {
        return moves.stream().map(m -> m.toString(toString)).collect(Collectors.joining(", ", "[", "]"));
    }
}

