/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import java.util.concurrent.atomic.AtomicLong;

public class SearchStatistics {
    private final AtomicLong evalCount = new AtomicLong();
    private final AtomicLong moveGenerationCount = new AtomicLong();
    private final AtomicLong generatedMoveCount = new AtomicLong();
    private final AtomicLong movePlayedCount = new AtomicLong();
    private final AtomicLong moveFromTTPlayedCount = new AtomicLong();
    private long startMs = System.currentTimeMillis();
    private boolean enabled = true;

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void clear() {
        this.startMs = System.currentTimeMillis();
        this.evalCount.set(0L);
        this.moveGenerationCount.set(0L);
        this.generatedMoveCount.set(0L);
        this.movePlayedCount.set(0L);
    }

    public long getEvaluationCount() {
        return this.evalCount.get();
    }

    public long getMoveGenerationCount() {
        return this.moveGenerationCount.get();
    }

    public long getGeneratedMoveCount() {
        return this.generatedMoveCount.get();
    }

    public long getMovePlayedCount() {
        return this.movePlayedCount.get();
    }

    public long getMoveFromTTPlayedCount() {
        return this.moveFromTTPlayedCount.get();
    }

    public void movePlayed() {
        this.movePlayedCount.incrementAndGet();
    }

    public void moveFromTTPlayed() {
        this.moveFromTTPlayedCount.incrementAndGet();
    }

    public void evaluationDone() {
        if (this.enabled) {
            this.evalCount.incrementAndGet();
        }
    }

    public void movesGenerated(int moveCount) {
        if (this.enabled) {
            this.moveGenerationCount.incrementAndGet();
            this.generatedMoveCount.addAndGet(moveCount);
        }
    }

    public long getDurationMs() {
        return System.currentTimeMillis() - this.startMs;
    }

    public String toString() {
        return this.enabled ? "SearchStatistics [moveGenerationCount=" + this.moveGenerationCount + ", generatedMoveCount=" + this.generatedMoveCount + ", movePlayedCount=" + this.movePlayedCount + ", evalCount=" + this.evalCount + "]" : "SearchStatistics are disabled";
    }
}

