/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.ai.SearchParameters;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluation;
import com.fathzer.games.util.SortedUtils;
import java.util.LinkedList;
import java.util.List;

public final class SearchResult<M> {
    private final LinkedList<EvaluatedMove<M>> result;
    private final SearchParameters params;

    public SearchResult(SearchParameters params) {
        this.params = params;
        this.result = new LinkedList();
    }

    public SearchParameters getSearchParameters() {
        return this.params;
    }

    synchronized int getLow() {
        return this.params.getLowerBound(this.result);
    }

    public synchronized void add(M move, Evaluation value) {
        SortedUtils.insert(this.result, new EvaluatedMove<M>(move, value));
    }

    public synchronized void update(M move, Evaluation value) {
        int index = this.getIndex(move);
        if (index >= 0) {
            this.result.remove(index);
        }
        this.add(move, value);
    }

    synchronized int getIndex(M move) {
        int index = 0;
        for (EvaluatedMove evaluatedMove : this.result) {
            if (evaluatedMove.getMove().equals(move)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public synchronized List<EvaluatedMove<M>> getCut() {
        return this.result.subList(0, this.params.getAccurateMovesCount(this.result));
    }

    public List<EvaluatedMove<M>> getList() {
        return this.result;
    }
}

