/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.ai.evaluation.EvaluatedMove;
import java.util.Iterator;
import java.util.List;

public class SearchParameters {
    private static final String SIZE_SHOULD_BE_STRICTLY_POSITIVE = "Size should be strictly positive";
    private static final String ACCURACY_SHOULD_BE_POSITIVE = "Accuracy should be positive";
    private int size;
    private int accuracy;

    public SearchParameters() {
        this(1, 0);
    }

    public SearchParameters(int size, int accuracy) {
        if (size <= 0) {
            throw new IllegalArgumentException(SIZE_SHOULD_BE_STRICTLY_POSITIVE);
        }
        if (accuracy < 0) {
            throw new IllegalArgumentException(ACCURACY_SHOULD_BE_POSITIVE);
        }
        this.size = size;
        this.accuracy = accuracy;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException(SIZE_SHOULD_BE_STRICTLY_POSITIVE);
        }
        this.size = size;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(int accuracy) {
        if (accuracy < 0) {
            throw new IllegalArgumentException(ACCURACY_SHOULD_BE_POSITIVE);
        }
        this.accuracy = accuracy;
    }

    public <M> int getLowerBound(List<EvaluatedMove<M>> moves) {
        return moves.size() >= this.size ? moves.get(this.size - 1).getScore() - this.accuracy - 1 : Integer.MIN_VALUE;
    }

    public <M> int getAccurateMovesCount(List<EvaluatedMove<M>> moves) {
        EvaluatedMove<M> ev;
        int count;
        int low = this.getLowerBound(moves);
        Iterator<EvaluatedMove<M>> iterator = moves.iterator();
        for (count = 0; iterator.hasNext() && ((ev = iterator.next()).getScore() > low || count < this.size); ++count) {
        }
        return count;
    }

    public <M> int getBestMovesCount(List<EvaluatedMove<M>> moves) {
        if (moves.isEmpty()) {
            return 0;
        }
        int low = moves.get(0).getScore() - this.accuracy;
        int count = 0;
        for (EvaluatedMove<M> ev : moves) {
            if (ev.getScore() < low) break;
            ++count;
        }
        return count;
    }
}

