/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.SearchStatistics;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.util.exec.Forkable;
import java.util.function.Supplier;

public class SearchContext<M, B extends MoveGenerator<M>>
implements Forkable<SearchContext<M, B>> {
    private final B gamePosition;
    private final Evaluator<M, B> evaluator;
    private SearchStatistics statistics;

    private SearchContext(B gamePosition, Evaluator<M, B> evaluator, SearchStatistics statistics) {
        this.gamePosition = gamePosition;
        this.evaluator = evaluator;
        this.statistics = statistics;
    }

    public B getGamePosition() {
        return this.gamePosition;
    }

    public Evaluator<M, B> getEvaluator() {
        return this.evaluator;
    }

    public SearchStatistics getStatistics() {
        return this.statistics;
    }

    public boolean makeMove(M move, MoveGenerator.MoveConfidence confidence) {
        this.evaluator.prepareMove(this.gamePosition, move);
        if (this.gamePosition.makeMove(move, confidence)) {
            this.evaluator.commitMove();
            return true;
        }
        return false;
    }

    public void unmakeMove() {
        this.evaluator.unmakeMove();
        this.gamePosition.unmakeMove();
    }

    @Override
    public SearchContext<M, B> fork() {
        MoveGenerator mg = (MoveGenerator)this.gamePosition.fork();
        Evaluator ev = (Evaluator)this.evaluator.fork();
        return new SearchContext<M, MoveGenerator>(mg, ev, this.statistics);
    }

    public static <M, B extends MoveGenerator<M>> SearchContext<M, B> get(B board, Supplier<Evaluator<M, B>> evaluatorBuilder) {
        MoveGenerator b = (MoveGenerator)board.fork();
        Evaluator<M, B> evaluator = evaluatorBuilder.get();
        evaluator.init(board);
        return new SearchContext<M, MoveGenerator>(b, evaluator, new SearchStatistics());
    }
}

