/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.HashProvider;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.Status;
import com.fathzer.games.ai.AbstractAI;
import com.fathzer.games.ai.DepthFirstSearchParameters;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.games.ai.SearchResult;
import com.fathzer.games.ai.evaluation.EvaluatedMove;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.evaluation.QuiesceEvaluator;
import com.fathzer.games.ai.transposition.AlphaBetaState;
import com.fathzer.games.ai.transposition.EntryType;
import com.fathzer.games.ai.transposition.TTAi;
import com.fathzer.games.ai.transposition.TranspositionTable;
import com.fathzer.games.ai.transposition.TranspositionTableEntry;
import com.fathzer.games.util.exec.ExecutionContext;
import java.util.List;

public class Negamax<M, B extends MoveGenerator<M>>
extends AbstractAI<M, B>
implements TTAi<M, B> {
    private TranspositionTable<M, B> transpositionTable;
    private QuiesceEvaluator<M, B> quiesceEvaluator = (ctx, depth, alpha, beta) -> {
        SearchContext context = this.getContext();
        context.getStatistics().evaluationDone();
        return context.getEvaluator().evaluate(context.getGamePosition());
    };

    public Negamax(ExecutionContext<SearchContext<M, B>> exec) {
        super(exec);
    }

    @Override
    public SearchResult<M> getBestMoves(DepthFirstSearchParameters params) {
        SearchResult result = super.getBestMoves(params);
        Object b = this.getContext().getGamePosition();
        if (b instanceof HashProvider) {
            HashProvider hp = (HashProvider)b;
            if (this.transpositionTable != null && !this.isInterrupted() && !result.getList().isEmpty()) {
                EvaluatedMove best = result.getList().get(0);
                this.transpositionTable.store(hp.getHashKey(), EntryType.EXACT, params.getDepth(), best.getScore(), best.getMove(), p -> true);
            }
        }
        return result;
    }

    @Override
    protected int getRootScore(int depth, int lowestInterestingScore) {
        return -this.negamax(depth - 1, depth, -2147483647, -lowestInterestingScore);
    }

    protected int quiesce(int depth, int alpha, int beta) {
        return this.quiesceEvaluator.evaluate(this.getContext(), depth, alpha, beta);
    }

    protected int negamax(int depth, int maxDepth, int alpha, int beta) {
        AlphaBetaState<M> state;
        long key;
        boolean keyProvider;
        SearchContext context = this.getContext();
        Object position = context.getGamePosition();
        Evaluator evaluator = context.getEvaluator();
        Status fastAnalysisStatus = position.getContextualStatus();
        if (fastAnalysisStatus != Status.PLAYING) {
            return this.getScore(evaluator, fastAnalysisStatus, depth, maxDepth);
        }
        boolean bl = keyProvider = position instanceof HashProvider && this.transpositionTable != null;
        if (keyProvider) {
            key = ((HashProvider)position).getHashKey();
            TranspositionTableEntry<M> entry = this.transpositionTable.get(key);
            state = this.transpositionTable.getPolicy().accept(entry, depth, alpha, beta, v -> this.ttToScore(v, depth, maxDepth, evaluator));
            if (state.isValueSet()) {
                return state.getValue();
            }
            if (state.isAlphaBetaUpdated()) {
                alpha = state.getAlphaUpdated();
                beta = state.getBetaUpdated();
            }
        } else {
            key = 0L;
            state = null;
        }
        if (depth == 0 || this.isInterrupted()) {
            return this.quiesce(maxDepth, alpha, beta);
        }
        int value = Integer.MIN_VALUE;
        Object bestMove = null;
        boolean noValidMove = true;
        Object moveFromTT = state != null ? (Object)state.getBestMove() : null;
        boolean moveFromTTBreaks = false;
        if (moveFromTT != null && this.getContext().makeMove(moveFromTT, MoveGenerator.MoveConfidence.UNSAFE)) {
            noValidMove = false;
            this.getStatistics().moveFromTTPlayed();
            int score = -this.negamax(depth - 1, maxDepth, -beta, -alpha);
            this.getContext().unmakeMove();
            if (score > value) {
                value = score;
                bestMove = moveFromTT;
                if (score > alpha) {
                    alpha = score;
                    if (score >= beta) {
                        moveFromTTBreaks = true;
                    }
                }
            }
        }
        if (!moveFromTTBreaks) {
            List moves = position.getMoves();
            this.getStatistics().movesGenerated(moves.size());
            for (Object move : moves) {
                if (move.equals(moveFromTT) || !this.getContext().makeMove(move, MoveGenerator.MoveConfidence.PSEUDO_LEGAL)) continue;
                noValidMove = false;
                this.getStatistics().movePlayed();
                int score = -this.negamax(depth - 1, maxDepth, -beta, -alpha);
                this.getContext().unmakeMove();
                if (score <= value) continue;
                value = score;
                bestMove = move;
                if (score <= alpha) continue;
                alpha = score;
                if (score < beta) continue;
                break;
            }
            if (noValidMove && (value = this.getScore(evaluator, position.getEndGameStatus(), depth, maxDepth)) > alpha) {
                alpha = value;
            }
        }
        if (keyProvider && !this.isInterrupted()) {
            state.setValue(value);
            state.updateAlphaBeta(alpha, beta);
            state.setBestMove(bestMove);
            this.transpositionTable.getPolicy().store(this.transpositionTable, key, state, v -> this.scoreToTT(v, depth, maxDepth, evaluator));
        }
        return value;
    }

    @Override
    public final TranspositionTable<M, B> getTranspositionTable() {
        return this.transpositionTable;
    }

    @Override
    public void setTranspositonTable(TranspositionTable<M, B> table) {
        this.transpositionTable = table;
    }

    public QuiesceEvaluator<M, B> getQuiesceEvaluator() {
        return this.quiesceEvaluator;
    }

    public void setQuiesceEvaluator(QuiesceEvaluator<M, B> quiesceEvaluator) {
        this.quiesceEvaluator = quiesceEvaluator;
    }
}

