/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.ai.SearchParameters;

public class DepthFirstSearchParameters
extends SearchParameters {
    private static final String DEPTH_SHOULD_BE_STRICTLY_POSITIVE = "Depth should be strictly positive";
    private int depth;

    public DepthFirstSearchParameters(int depth) {
        this(depth, 1, 0);
    }

    public DepthFirstSearchParameters(int depth, int size, int accuracy) {
        super(size, accuracy);
        if (depth <= 0) {
            throw new IllegalArgumentException(DEPTH_SHOULD_BE_STRICTLY_POSITIVE);
        }
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth <= 0) {
            throw new IllegalArgumentException(DEPTH_SHOULD_BE_STRICTLY_POSITIVE);
        }
        this.depth = depth;
    }
}

