/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games.ai;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.Status;
import com.fathzer.games.ai.DepthFirstAI;
import com.fathzer.games.ai.DepthFirstSearchParameters;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.games.ai.SearchResult;
import com.fathzer.games.ai.SearchStatistics;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.util.exec.ExecutionContext;
import com.fathzer.games.util.exec.Interruptible;
import java.util.List;
import java.util.function.BiFunction;

public abstract class AbstractAI<M, B extends MoveGenerator<M>>
implements DepthFirstAI<M, DepthFirstSearchParameters>,
Interruptible {
    private final ExecutionContext<SearchContext<M, B>> context;
    private boolean interrupted;

    protected AbstractAI(ExecutionContext<SearchContext<M, B>> context) {
        this.context = context;
        this.interrupted = false;
    }

    @Override
    public SearchStatistics getStatistics() {
        return this.context.getContext().getStatistics();
    }

    public SearchContext<M, B> getContext() {
        return this.context.getContext();
    }

    @Override
    public SearchResult<M> getBestMoves(DepthFirstSearchParameters params) {
        this.getContext().getStatistics().clear();
        List moves = this.getContext().getGamePosition().getMoves();
        this.getStatistics().movesGenerated(moves.size());
        return this.getBestMoves(moves, params);
    }

    @Override
    public SearchResult<M> getBestMoves(List<M> moves, DepthFirstSearchParameters params) {
        return this.getBestMoves(moves, params, (m, lowestInterestingScore) -> this.rootEvaluation((M)m, params.getDepth(), (int)lowestInterestingScore));
    }

    protected Integer rootEvaluation(M move, int depth, int lowestInterestingScore) {
        if (lowestInterestingScore == Integer.MIN_VALUE) {
            ++lowestInterestingScore;
        }
        if (this.context.getContext().makeMove(move, MoveGenerator.MoveConfidence.UNSAFE)) {
            this.getStatistics().movePlayed();
            int score = this.getRootScore(depth, lowestInterestingScore);
            this.context.getContext().unmakeMove();
            return score;
        }
        return null;
    }

    protected abstract int getRootScore(int var1, int var2);

    protected SearchResult<M> getBestMoves(List<M> moves, DepthFirstSearchParameters params, BiFunction<M, Integer, Integer> rootEvaluator) {
        SearchResult search = new SearchResult(params);
        this.context.execute(moves.stream().map(m -> this.getRootEvaluationTask(rootEvaluator, search, m)).toList());
        return search;
    }

    private Runnable getRootEvaluationTask(BiFunction<M, Integer, Integer> rootEvaluator, SearchResult<M> search, M m) {
        return () -> {
            Integer score = (Integer)rootEvaluator.apply(m, search.getLow());
            if (!this.isInterrupted() && score != null) {
                search.add(m, this.getContext().getEvaluator().toEvaluation(score));
            }
        };
    }

    @Override
    public boolean isInterrupted() {
        return this.interrupted;
    }

    @Override
    public void interrupt() {
        this.interrupted = true;
    }

    protected int getScore(Evaluator<M, B> evaluator, Status status, int depth, int maxDepth) {
        if (Status.DRAW == status) {
            return 0;
        }
        return -evaluator.getWinScore(maxDepth - depth);
    }
}

