/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.games;

import com.fathzer.games.Status;
import com.fathzer.games.util.exec.Forkable;
import java.util.List;

public interface MoveGenerator<M>
extends Forkable<MoveGenerator<M>> {
    public boolean isWhiteToMove();

    public boolean makeMove(M var1, MoveConfidence var2);

    public void unmakeMove();

    public List<M> getMoves();

    default public List<M> getLegalMoves() {
        return this.getMoves().stream().filter(m -> {
            boolean ok = this.makeMove(m, MoveConfidence.PSEUDO_LEGAL);
            if (ok) {
                this.unmakeMove();
            }
            return ok;
        }).toList();
    }

    default public Status getContextualStatus() {
        return Status.PLAYING;
    }

    public Status getEndGameStatus();

    public static enum MoveConfidence {
        LEGAL,
        PSEUDO_LEGAL,
        UNSAFE;

    }
}

