/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators.simplified;

class FastPhaseDetector {
    private static final long BLACK_QUEEN_VALUE = 1L;
    private static final long BLACK_QUEEN_MASK = 255L;
    private static final long WHITE_QUEEN_VALUE = 256L;
    private static final long WHITE_QUEEN_MASK = 65280L;
    private static final long BLACK_ROOK_VALUE = 65536L;
    private static final long BLACK_ROOK_MASK = 0xFF0000L;
    private static final long WHITE_ROOK_VALUE = 0x1000000L;
    private static final long WHITE_ROOK_MASK = 0xFF000000L;
    private static final long BLACK_MINOR_VALUE = 0x100000000L;
    private static final long BLACK_MINOR_MASK = 0xFF00000000L;
    private static final long WHITE_MINOR_VALUE = 0x10000000000L;
    private static final long WHITE_MINOR_MASK = 0xFF0000000000L;
    private static final long[] PIECE_KIND_TO_VALUES = new long[]{0L, 1L, 65536L, 0x100000000L, 0x100000000L, 0L, 0L, 0L, 0x10000000000L, 0x10000000000L, 0x1000000L, 256L, 0L};
    private long state;

    FastPhaseDetector() {
    }

    void add(int piece) {
        this.state += PIECE_KIND_TO_VALUES[piece + 6];
    }

    void remove(int piece) {
        this.state -= PIECE_KIND_TO_VALUES[piece + 6];
    }

    boolean isEndGamePhase() {
        boolean blackQueen;
        boolean whiteQueen = (this.state & 0xFF00L) != 0L;
        boolean bl = blackQueen = (this.state & 0xFFL) != 0L;
        if (!blackQueen && !whiteQueen) {
            return true;
        }
        return (!blackQueen || !this.hasBlackRook() && !this.hasManyBlackMinor()) && (!whiteQueen || !this.hasWhiteRook() && !this.hasManyWhiteMinor());
    }

    boolean hasWhiteRook() {
        return (this.state & 0xFF000000L) != 0L;
    }

    boolean hasBlackRook() {
        return (this.state & 0xFF0000L) != 0L;
    }

    boolean hasManyBlackMinor() {
        return (this.state & 0xFF00000000L) > 0x100000000L;
    }

    boolean hasManyWhiteMinor() {
        return (this.state & 0xFF0000000000L) > 0x10000000000L;
    }

    void copyTo(FastPhaseDetector other) {
        other.state = this.state;
    }
}

