/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators.simplified;

import com.fathzer.chess.utils.evaluators.AbstractChessEvaluator;
import com.fathzer.chess.utils.evaluators.AbstractPieceSquareTable;
import com.fathzer.chess.utils.evaluators.simplified.EndGameKingSquareTable;
import com.fathzer.chess.utils.evaluators.simplified.KingSquareTable;
import com.fathzer.chess.utils.evaluators.simplified.PiecesOnlySquareTable;
import com.fathzer.chess.utils.evaluators.simplified.SimplifiedState;
import com.fathzer.games.MoveGenerator;

public abstract class AbstractIncrementalSimplifiedEvaluator<M, B extends MoveGenerator<M>>
extends AbstractChessEvaluator<M, B, SimplifiedState> {
    private static final AbstractPieceSquareTable POS_TABLE = new PiecesOnlySquareTable();
    private static final AbstractPieceSquareTable MIDDLE_GAME_KING_TABLE = new KingSquareTable();
    private static final AbstractPieceSquareTable END_GAME_KING_TABLE = new EndGameKingSquareTable();

    protected AbstractIncrementalSimplifiedEvaluator() {
        super(SimplifiedState::new);
    }

    protected AbstractIncrementalSimplifiedEvaluator(SimplifiedState state) {
        super(SimplifiedState::new, state);
    }

    @Override
    protected void clear(SimplifiedState state) {
        state.points = 0;
    }

    @Override
    protected void copy(SimplifiedState from, SimplifiedState to) {
        from.copyTo(to);
    }

    @Override
    protected void put(int pieceType, boolean isBlack, int to) {
        this.add(pieceType, isBlack, to);
        this.updateKingPositions(pieceType, isBlack, to);
    }

    @Override
    protected void add(int pieceType, boolean isBlack, int to) {
        ((SimplifiedState)this.toCommit).points += POS_TABLE.get(pieceType, isBlack, to);
        ((SimplifiedState)this.toCommit).add(isBlack ? -pieceType : pieceType);
    }

    @Override
    protected void move(int pieceType, boolean isBlack, int from, int to) {
        ((SimplifiedState)this.toCommit).points -= POS_TABLE.get(pieceType, isBlack, from);
        ((SimplifiedState)this.toCommit).points += POS_TABLE.get(pieceType, isBlack, to);
        this.updateKingPositions(pieceType, isBlack, to);
    }

    @Override
    protected void remove(int pieceType, boolean isBlack, int from) {
        ((SimplifiedState)this.toCommit).points -= POS_TABLE.get(pieceType, isBlack, from);
        ((SimplifiedState)this.toCommit).remove(isBlack ? -pieceType : pieceType);
    }

    private void updateKingPositions(int pieceType, boolean isBlack, int to) {
        if (pieceType == 6) {
            if (isBlack) {
                ((SimplifiedState)this.toCommit).blackKingIndex = to;
            } else {
                ((SimplifiedState)this.toCommit).whiteKingIndex = to;
            }
        }
    }

    @Override
    public int evaluateAsWhite(B board) {
        SimplifiedState state = (SimplifiedState)this.getState();
        AbstractPieceSquareTable kingsTable = state.isEndGamePhase() ? END_GAME_KING_TABLE : MIDDLE_GAME_KING_TABLE;
        return state.points + kingsTable.get(6, false, state.whiteKingIndex) + kingsTable.get(6, true, state.blackKingIndex);
    }
}

