/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators.quiesce;

import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.SearchContext;
import com.fathzer.games.ai.SearchStatistics;
import com.fathzer.games.ai.evaluation.QuiesceEvaluator;
import java.util.List;

public abstract class AbstractBasicQuiesceEvaluator<M, B extends MoveGenerator<M>>
implements QuiesceEvaluator<M, B> {
    protected AbstractBasicQuiesceEvaluator() {
    }

    @Override
    public int evaluate(SearchContext<M, B> context, int depth, int alpha, int beta) {
        return this.quiesce(context, alpha, beta, depth, 0);
    }

    private int quiesce(SearchContext<M, B> context, int alpha, int beta, int rootDepth, int quiesceDepth) {
        SearchStatistics statistics = context.getStatistics();
        boolean check = this.isCheck(context);
        if (!check) {
            int standPat = context.getEvaluator().evaluate(context.getGamePosition());
            statistics.evaluationDone();
            if (standPat >= beta) {
                return beta;
            }
            if (alpha < standPat) {
                alpha = standPat;
            }
        }
        List<M> moves = this.getMoves(context, quiesceDepth);
        statistics.movesGenerated(moves.size());
        boolean mate = check;
        for (M move : moves) {
            if (!this.makeMove(context, move)) continue;
            mate = false;
            statistics.movePlayed();
            int score = -this.quiesce(context, -beta, -alpha, rootDepth, quiesceDepth + 1);
            context.unmakeMove();
            if (score >= beta) {
                return beta;
            }
            if (score <= alpha) continue;
            alpha = score;
        }
        return mate ? -context.getEvaluator().getWinScore(rootDepth + quiesceDepth) : alpha;
    }

    protected abstract boolean isCheck(SearchContext<M, B> var1);

    protected abstract List<M> getMoves(SearchContext<M, B> var1, int var2);

    protected boolean makeMove(SearchContext<M, B> context, M move) {
        return context.makeMove(move, MoveGenerator.MoveConfidence.PSEUDO_LEGAL);
    }
}

