/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators.pesto;

import com.fathzer.chess.utils.evaluators.AbstractChessEvaluator;
import com.fathzer.chess.utils.evaluators.AbstractPieceSquareTable;
import com.fathzer.chess.utils.evaluators.pesto.EndGamePieceSquareTable;
import com.fathzer.chess.utils.evaluators.pesto.MiddleGamePieceSquareTable;
import com.fathzer.chess.utils.evaluators.pesto.PestoState;
import com.fathzer.games.MoveGenerator;

public abstract class AbstractIncrementalPestoEvaluator<M, B extends MoveGenerator<M>>
extends AbstractChessEvaluator<M, B, PestoState> {
    private static final AbstractPieceSquareTable MIDDLE_GAME_TABLE = new MiddleGamePieceSquareTable();
    private static final AbstractPieceSquareTable END_GAME_TABLE = new EndGamePieceSquareTable();
    private static final int[] GAME_PHASE_WEIGHT = new int[]{0, 0, 1, 1, 2, 4, 0};

    protected AbstractIncrementalPestoEvaluator() {
        super(PestoState::new);
    }

    protected AbstractIncrementalPestoEvaluator(PestoState state) {
        super(PestoState::new, state);
    }

    @Override
    protected void clear(PestoState state) {
        state.clear();
    }

    @Override
    protected void copy(PestoState from, PestoState to) {
        from.copyTo(to);
    }

    @Override
    protected void add(int pieceType, boolean isBlack, int to) {
        ((PestoState)this.toCommit).mgPoints += MIDDLE_GAME_TABLE.get(pieceType, isBlack, to);
        ((PestoState)this.toCommit).egPoints += END_GAME_TABLE.get(pieceType, isBlack, to);
        ((PestoState)this.toCommit).phasePoints += GAME_PHASE_WEIGHT[pieceType];
    }

    @Override
    protected void move(int pieceType, boolean isBlack, int from, int to) {
        ((PestoState)this.toCommit).mgPoints -= MIDDLE_GAME_TABLE.get(pieceType, isBlack, from);
        ((PestoState)this.toCommit).mgPoints += MIDDLE_GAME_TABLE.get(pieceType, isBlack, to);
        ((PestoState)this.toCommit).egPoints -= END_GAME_TABLE.get(pieceType, isBlack, from);
        ((PestoState)this.toCommit).egPoints += END_GAME_TABLE.get(pieceType, isBlack, to);
    }

    @Override
    protected void remove(int pieceType, boolean isBlack, int from) {
        ((PestoState)this.toCommit).mgPoints -= MIDDLE_GAME_TABLE.get(pieceType, isBlack, from);
        ((PestoState)this.toCommit).egPoints -= END_GAME_TABLE.get(pieceType, isBlack, from);
        ((PestoState)this.toCommit).phasePoints -= GAME_PHASE_WEIGHT[pieceType];
    }

    @Override
    public int evaluateAsWhite(B board) {
        PestoState state = (PestoState)this.getState();
        int mgPhase = Math.min(state.phasePoints, 24);
        int egPhase = 24 - mgPhase;
        return (state.mgPoints * mgPhase + state.egPoints * egPhase) / 24;
    }
}

