/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators;

import com.fathzer.chess.utils.adapters.BoardExplorer;

public abstract class AbstractPieceSquareTable {
    protected AbstractPieceSquareTable() {
    }

    public int getRawEvaluation(BoardExplorer explorer) {
        int points = 0;
        do {
            int p = explorer.getPiece();
            int piece = Math.abs(p);
            int index = explorer.getIndex();
            boolean isBlack = p < 0;
            points += this.get(piece, isBlack, index);
        } while (explorer.next());
        return points;
    }

    protected abstract int get(int var1, int var2);

    public final int get(int pieceType, boolean black, int index) {
        return black ? -this.get(pieceType, index ^ 0x38) : this.get(pieceType, index);
    }

    protected static void addPiecesValues(int[][] pieceSquareTable, int[] pieceValues) {
        for (int i = 0; i < pieceValues.length; ++i) {
            AbstractPieceSquareTable.add(pieceSquareTable[i], pieceValues[i]);
        }
    }

    private static void add(int[] array, int value) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i] + value;
        }
    }
}

