/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators;

import com.fathzer.chess.utils.Pieces;
import com.fathzer.chess.utils.adapters.BoardExplorerBuilder;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.evaluation.ZeroSumEvaluator;
import com.fathzer.games.util.Stack;

public abstract class AbstractNaiveEvaluator<M, B extends MoveGenerator<M>>
implements ZeroSumEvaluator<M, B>,
Evaluator<M, B>,
BoardExplorerBuilder<B> {
    private final Stack<Integer> scores = new Stack(null);
    private int toCommit;

    protected AbstractNaiveEvaluator() {
    }

    protected AbstractNaiveEvaluator(int score) {
        this.scores.set(score);
    }

    protected abstract int getCapturedType(B var1, M var2);

    protected abstract int getPromotionType(B var1, M var2);

    @Override
    public void init(B board) {
        this.scores.clear();
        this.scores.set(this.getPieces(board).map(p -> p > 0 ? Pieces.getPoints(p) : -Pieces.getPoints(-p)).sum());
    }

    @Override
    public int evaluateAsWhite(B board) {
        return 100 * this.scores.get();
    }

    protected abstract AbstractNaiveEvaluator<M, B> fork(int var1);

    @Override
    public AbstractNaiveEvaluator<M, B> fork() {
        return this.fork(this.scores.get());
    }

    @Override
    public void prepareMove(B board, M move) {
        int promotion;
        int increment = 0;
        int capturedPiece = this.getCapturedType(board, move);
        if (capturedPiece != 0) {
            increment = Pieces.getPoints(capturedPiece);
        }
        if ((promotion = this.getPromotionType(board, move)) != 0) {
            increment = increment + Pieces.getPoints(promotion) - Pieces.getPoints(1);
        }
        if (!board.isWhiteToMove()) {
            increment = -increment;
        }
        this.toCommit = this.scores.get() + increment;
    }

    @Override
    public void commitMove() {
        this.scores.next();
        this.scores.set(this.toCommit);
    }

    @Override
    public void unmakeMove() {
        this.scores.previous();
    }
}

