/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils.evaluators;

import com.fathzer.chess.utils.adapters.BoardExplorer;
import com.fathzer.chess.utils.adapters.BoardExplorerBuilder;
import com.fathzer.chess.utils.adapters.MoveData;
import com.fathzer.games.MoveGenerator;
import com.fathzer.games.ai.evaluation.Evaluator;
import com.fathzer.games.ai.evaluation.ZeroSumEvaluator;
import com.fathzer.games.util.Stack;
import java.util.function.Supplier;

public abstract class AbstractChessEvaluator<M, B extends MoveGenerator<M>, S>
implements ZeroSumEvaluator<M, B>,
BoardExplorerBuilder<B>,
Supplier<MoveData<M, B>> {
    private final Stack<S> states;
    protected S toCommit;
    private MoveData<M, B> moveData;

    protected AbstractChessEvaluator(Supplier<S> stateBuilder) {
        this.states = new Stack<S>(stateBuilder);
        this.toCommit = stateBuilder.get();
        this.moveData = (MoveData)this.get();
    }

    protected AbstractChessEvaluator(Supplier<S> stateBuilder, S state) {
        this(stateBuilder);
        this.copy(state, this.toCommit);
        this.states.set(state);
    }

    @Override
    public void init(B board) {
        this.states.clear();
        this.clear(this.toCommit);
        this.init(this.getExplorer(board));
        this.states.set(this.toCommit);
    }

    @Override
    protected void init(BoardExplorer explorer) {
        do {
            int p = explorer.getPiece();
            int kind = Math.abs(p);
            int index = explorer.getIndex();
            boolean isBlack = p < 0;
            this.put(kind, isBlack, index);
        } while (explorer.next());
    }

    @Override
    public final void prepareMove(B board, M move) {
        if (this.moveData.update(move, board)) {
            this.buildToCommit();
            this.prepareMove(this.moveData);
        }
    }

    private void buildToCommit() {
        S current = this.states.get();
        this.states.next();
        this.toCommit = this.states.get();
        this.states.previous();
        this.copy(current, this.toCommit);
    }

    @Override
    public final void commitMove() {
        this.states.next();
        this.states.set(this.toCommit);
    }

    @Override
    public final void unmakeMove() {
        this.states.previous();
    }

    protected void prepareMove(MoveData<M, B> moveData) {
        int promoType;
        boolean isBlack = moveData.getMovingPiece() < 0;
        int pieceType = Math.abs(moveData.getMovingPiece());
        int movingIndex = moveData.getMovingIndex();
        int rookIndex = moveData.getCastlingRookIndex();
        if (rookIndex >= 0) {
            this.move(4, isBlack, rookIndex, moveData.getCastlingRookDestinationIndex());
            this.move(6, isBlack, movingIndex, moveData.getMovingDestination());
            return;
        }
        int captured = moveData.getCapturedType();
        if (captured != 0) {
            this.remove(captured, !isBlack, moveData.getCapturedIndex());
        }
        if ((promoType = moveData.getPromotionType()) != 0) {
            this.remove(pieceType, isBlack, movingIndex);
            pieceType = promoType;
            this.add(pieceType, isBlack, moveData.getMovingDestination());
        } else {
            this.move(pieceType, isBlack, movingIndex, moveData.getMovingDestination());
        }
    }

    @Override
    public Evaluator<M, B> fork() {
        return this.fork(this.states.get());
    }

    protected abstract AbstractChessEvaluator<M, B, S> fork(S var1);

    protected abstract void clear(S var1);

    protected abstract void copy(S var1, S var2);

    protected S getState() {
        return this.states.get();
    }

    protected abstract void add(int var1, boolean var2, int var3);

    protected abstract void move(int var1, boolean var2, int var3, int var4);

    protected abstract void remove(int var1, boolean var2, int var3);

    protected void put(int pieceType, boolean isBlack, int to) {
        this.add(pieceType, isBlack, to);
    }
}

