/*
 * Decompiled with CFR 0.152.
 */
package com.fathzer.chess.utils;

import com.fathzer.chess.utils.Pieces;
import com.fathzer.games.util.SelectiveComparator;

public abstract class AbstractDefaultMoveComparator<M, B>
implements SelectiveComparator<M> {
    protected final B board;

    protected AbstractDefaultMoveComparator(B board) {
        this.board = board;
    }

    protected abstract int getMovingPiece(B var1, M var2);

    protected abstract int getCapturedType(B var1, M var2);

    protected abstract int getPromotionType(B var1, M var2);

    @Override
    public int compare(M o1, M o2) {
        return Integer.compare(this.evaluate(o2), this.evaluate(o1));
    }

    @Override
    public boolean test(M t) {
        return this.evaluate(t) != 0;
    }

    public int evaluate(M move) {
        int promotion = this.getPromotionType(this.board, move);
        int value = promotion == 0 ? 0 : (Pieces.getPoints(promotion) - 1) * 16;
        int captured = this.getCapturedType(this.board, move);
        if (captured == 0) {
            return value;
        }
        return (value += Pieces.getPoints(captured) * 16) - Pieces.getPoints(Math.abs(this.getMovingPiece(this.board, move)));
    }
}

